<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- ================================================================= -->
<!-- constants 														   -->
<!-- ================================================================= -->
<xsl:include href="constants-DE-de.xsl"/>
<xsl:variable name="ordertype">Ordertype</xsl:variable>
<xsl:variable name="blank"><xsl:text>&#160;</xsl:text></xsl:variable>
<xsl:variable name="comma_blank"><xsl:text>, &#160;</xsl:text></xsl:variable>

<!-- ================================================================= -->
<!-- table styles 													   -->
<!-- ================================================================= -->
<xsl:attribute-set name="table-header">
	<xsl:attribute name="style">border-width: 1pt; border-color: black; border-style:solid;</xsl:attribute>
</xsl:attribute-set>
<xsl:attribute-set name="table-header_collapsed">
	<xsl:attribute name="style">border-width: 1pt; border-color: black; border-style:solid; border-collapse:collapse; width: 100%</xsl:attribute>
</xsl:attribute-set>
<xsl:attribute-set name="table-header_lightgrey">
	<xsl:attribute name="style">background-color:lightgray</xsl:attribute>
</xsl:attribute-set>
<xsl:attribute-set name="section-header">
	<xsl:attribute name="colspan">2</xsl:attribute>
	<xsl:attribute name="style">text-align: left; border-width: 1pt; border-color: black; border-style:solid; background-color:#CCCCCC;</xsl:attribute>
</xsl:attribute-set>
<xsl:attribute-set name="section-title">
	<xsl:attribute name="style">vertical-align:top; border-width: 1pt; border-color: black; border-style:solid; width: 20%;</xsl:attribute>
</xsl:attribute-set>

<!-- ================================================================= -->
<!-- wrap text after 10 characters 									   -->
<!-- ================================================================= -->
<xsl:template name="textwrap">
	<xsl:param name="text"/>
	<xsl:choose>
		<xsl:when test="string-length($text) &gt; 10">
			<xsl:value-of select="substring($text, 1, 10)"/>
			<wbr/>
			<xsl:call-template name="textwrap">
				<xsl:with-param name="text" select="substring($text, 11)" />
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$text"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- ================================================================= -->
<!-- fap report 													   -->
<!-- ================================================================= -->
<xsl:template match="/RESULTS">
<html>
	<head>
		<title><xsl:value-of select="RESULT/TITLE"/></title>
	</head>
	<body>
		<h1 style="text-align:center;"><xsl:value-of select="RESULT/TITLE"/></h1>
		<br/>
		<!-- vehicle and tester informations -->
		<table>
			<tr>
				<td><h3><xsl:value-of select="$i18n-vehicledata"/></h3></td>
				<td><xsl:value-of select="$blank"/></td>
				<td></td>
				<td style='width:120px'></td>
				<td><h3><xsl:value-of select="$i18n-testerdata"/></h3></td>
				<td><xsl:value-of select="$blank"/></td>
				<td></td>
			</tr>
			<tr>
				<td><xsl:value-of select="$i18n-creation-date"/>:</td>
				<td><xsl:value-of select="$blank"/></td>
				<td><xsl:value-of select="RESULT/HEADER/END_TEST"/></td>
				<td></td>
				<td><xsl:value-of select="$i18n-dealer"/>:</td>
				<td><xsl:value-of select="$blank"/></td>
				<td><xsl:value-of select="RESULTSHEADER/CARDEALER/DEALERNO"/></td>
			</tr>
			<tr>
				<td><xsl:value-of select="$i18n-vin"/>:</td>
				<td><xsl:value-of select="$blank"/></td>
				<td><xsl:value-of select="RESULTSHEADER/VEHICLE/IDENT/VIN"/></td>
				<td></td>
				<td><xsl:value-of select="$i18n-testerid"/>:</td>
				<td><xsl:value-of select="$blank"/></td>
				<td><xsl:value-of select="RESULT/HEADER/EQUIPMENT/SERIAL_NO"/></td>
			</tr>
			<tr>
				<td><xsl:value-of select="$i18n-platform"/>:</td>
				<td><xsl:value-of select="$blank"/></td>
				<td><xsl:value-of select="RESULTSHEADER/VEHICLE/DATA/MODELTYPE"/></td>
				<td></td>
				<td><xsl:value-of select="$i18n-appversion"/>:</td>
				<td><xsl:value-of select="$blank"/></td>
				<td><xsl:value-of select="RESULT/HEADER/EQUIPMENT/VERSION"/></td>
			</tr>
			<tr>
				<td><xsl:value-of select="$i18n-ordertype"/>:</td>
				<td><xsl:value-of select="$blank"/></td>
				<td><xsl:value-of select="RESULTSHEADER/VEHICLE/DATA/ORDERTYPE"/></td>
				<td></td>
				<td><xsl:value-of select="$i18n-pt2gversion"/>:</td>
				<td><xsl:value-of select="$blank"/></td>
				<td><xsl:value-of select="RESULT/HEADER/EQUIPMENT/PT2GVERSION"/></td>
			</tr>
			<tr>
				<td><xsl:value-of select="$i18n-mileage"/>:</td>
				<td><xsl:value-of select="$blank"/></td>
				<td>
					<xsl:value-of select="RESULTSHEADER/VEHICLE/DATA/ODOMETER"/>
					<xsl:value-of select="$blank"/>
					<xsl:value-of select="RESULTSHEADER/VEHICLE/DATA/ODOMETER/@UNIT"/>
				</td>
				<td></td>
				<td><xsl:value-of select="$i18n-platformpdx"/>:</td>
				<td><xsl:value-of select="$blank"/></td>
				<td><xsl:value-of select="RESULT/HEADER/EQUIPMENT/BR_PDX"/></td>
			</tr>
			<tr>
				<td><xsl:value-of select="$i18n-operating-time"/>:</td>
				<td><xsl:value-of select="$blank"/></td>
				<td>
					<xsl:value-of select="RESULTSHEADER/VEHICLE/DATA/OPERATINGTIME"/>
					<xsl:value-of select="$blank"/>
					<xsl:value-of select="RESULTSHEADER/VEHICLE/DATA/OPERATINGTIME/@UNIT"/>
				</td>
				<td></td>
				<td><xsl:value-of select="$i18n-vci"/>:</td>
				<td><xsl:value-of select="$blank"/></td>
				<td><xsl:value-of select="RESULT/HEADER/EQUIPMENT/MODEL"/></td>
			</tr>
			<tr>
				<td><xsl:value-of select="$i18n-gearboxtype"/>:</td>
				<td><xsl:value-of select="$blank"/></td>
				<td><xsl:value-of select="RESULTSHEADER/VEHICLE/DATA/GEARBOXTYPE"/></td>
				<td></td>
				<td><xsl:value-of select="$i18n-pduapiversion"/>:</td>
				<td><xsl:value-of select="$blank"/></td>
				<td><xsl:value-of select="RESULT/HEADER/EQUIPMENT/PDU_API"/></td>
			</tr>
			<tr>
				<td><xsl:value-of select="$i18n-enginetype"/>:</td>
				<td><xsl:value-of select="$blank"/></td>
				<td><xsl:value-of select="RESULTSHEADER/VEHICLE/DATA/ENGINETYPE"/></td>
				<td></td>
				<td><xsl:value-of select="$i18n-operatingsystem"/>:</td>
				<td><xsl:value-of select="$blank"/></td>
				<td><xsl:value-of select="RESULT/HEADER/EQUIPMENT/SYSTEM"/></td>
			</tr>
			<tr>
				<td><xsl:value-of select="$i18n-country"/>:</td>
				<td><xsl:value-of select="$blank"/></td>
				<td><xsl:value-of select="RESULTSHEADER/VEHICLE/DATA/COUNTRYCODE"/></td>
				<td></td>
				<td><xsl:value-of select="$i18n-javaversion"/>:</td>
				<td><xsl:value-of select="$blank"/></td>
				<td><xsl:value-of select="RESULT/HEADER/EQUIPMENT/JAVA"/></td>
			</tr>
			<tr>
				<td><xsl:value-of select="$i18n-protocoltype"/>:</td>
				<td><xsl:value-of select="$blank"/></td>
				<xsl:variable name="p" select="RESULT/HEADER/PROTOKOLLTYPE"/>
				<td>
					<xsl:choose>
						<xsl:when test="$p='BEFOREREP'"><xsl:value-of select="$i18n-beforerep"/></xsl:when>
						<xsl:when test="$p='AFTERREP'"><xsl:value-of select="$i18n-afterrep"/></xsl:when>
						<xsl:when test="$p='WHILEREP'"><xsl:value-of select="$i18n-whilerep"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$i18n-other"/></xsl:otherwise>
					</xsl:choose>
				</td>
				<td></td>
				<td><xsl:value-of select="$i18n-usermode"/>:</td>
				<td><xsl:value-of select="$blank"/></td>
				<td><xsl:value-of select="RESULT/HEADER/EQUIPMENT/MODE"/></td>
			</tr>
			<tr>
				<td><xsl:value-of select="$i18n-voltage"/>:</td>
				<td><xsl:value-of select="$blank"/></td>
				<td>
					<xsl:value-of select="RESULTSHEADER/VEHICLE/DATA/ONBOARDVOLTAGE"/>
					<xsl:value-of select="$blank"/>
					<xsl:value-of select="RESULTSHEADER/VEHICLE/DATA/ONBOARDVOLTAGE/@UNIT"/>
				</td>
			</tr>
		</table>
		<br/><br/>

		<!-- overview table with all devices and selective attributes -->
		<a name="toc"></a>
		<h2><xsl:value-of select="$i18n-overview"/></h2>
		<table xsl:use-attribute-sets="table-header_collapsed">
			<tr xsl:use-attribute-sets="table-header_lightgrey">
				<th xsl:use-attribute-sets="table-header"><xsl:value-of select="$i18n-ecu"/></th>
				<th xsl:use-attribute-sets="table-header"><xsl:value-of select="$i18n-sparepartno"/></th>
				<th xsl:use-attribute-sets="table-header"><xsl:value-of select="$i18n-serialno"/></th>
				<th xsl:use-attribute-sets="table-header"><xsl:value-of select="$i18n-dsn"/></th>
				<th xsl:use-attribute-sets="table-header"><xsl:value-of select="$i18n-software"/></th>
				<th xsl:use-attribute-sets="table-header"><xsl:value-of select="$i18n-hardware"/></th>
				<th xsl:use-attribute-sets="table-header"><xsl:value-of select="$i18n-errortypes"/></th>
			</tr>
			<xsl:for-each select="RESULT/SECTION[@OBJECT='ECU']">
				<tr>
					<td xsl:use-attribute-sets="table-header"><a href="#{generate-id(.)}"><xsl:value-of select="TITLE"/></a></td>
					<td xsl:use-attribute-sets="table-header"><xsl:value-of select="MEAS/VALUE[@LABEL='SGIDK2']"/></td>
					<td xsl:use-attribute-sets="table-header"><xsl:value-of select="MEAS/VALUE[@LABEL='SERNR']"/></td>
					<td xsl:use-attribute-sets="table-header"><xsl:value-of select="MEAS/VALUE[@LABEL='SGIDK1']"/></td>
					<td xsl:use-attribute-sets="table-header">
						<!-- there a 2 possible labels for this -->
						<xsl:if test="MEAS/VALUE[@LABEL='PIF']">
							<xsl:value-of select="MEAS/VALUE[@LABEL='PIF']"/>
						</xsl:if>
						<xsl:if test="MEAS/VALUE[@LABEL='ZIF']">
							<xsl:value-of select="MEAS/VALUE[@LABEL='ZIF']"/>
						</xsl:if>
					</td>
					<td xsl:use-attribute-sets="table-header"><xsl:value-of select="MEAS/VALUE[@LABEL='BRIF']"/></td>
					<td xsl:use-attribute-sets="table-header">
						<xsl:for-each select="MEAS[@OBJECT='Fehler']/VALUE">
							<xsl:value-of select="." />
							<!-- delete last comma -->
							<xsl:if test="position() != last()"><xsl:value-of select="$comma_blank"/></xsl:if>
							<!-- line break after two troublecodes -->
							<xsl:if test="(position()-1) mod 2"><br/></xsl:if>
						</xsl:for-each>
					</td>
				</tr>
			</xsl:for-each>
		</table>

		<!-- overview of coding for each device -->
		<a name="codingtable"></a>
		<h2><xsl:value-of select="$i18n-overview-coding"/></h2>
		<table xsl:use-attribute-sets="table-header_collapsed">
			<tr xsl:use-attribute-sets="table-header_lightgrey">
				<th xsl:use-attribute-sets="table-header"><xsl:value-of select="$i18n-ecu"/></th>
				<th xsl:use-attribute-sets="table-header"><xsl:value-of select="$i18n-coding"/></th>
			</tr>
			<!-- generate a row for each device with measurement 'Codierung' which has one or more childs -->
			<xsl:for-each select="RESULT/SECTION[@OBJECT='ECU']">
				<xsl:if test="MEAS[@OBJECT='Codierung'] and count(child::*) > 0">
					<tr>
						<td style="border-width: 1pt; border-color: black; border-style:solid; vertical-align:top;">
						<a name="{generate-id(TITLE)}" href="#{generate-id(.)}"><xsl:value-of select="TITLE"/></a>
						</td>
						<td xsl:use-attribute-sets="table-header">
						<xsl:apply-templates select="MEAS[@OBJECT='Codierung']" mode="overview"/>
						</td>
					</tr>
				</xsl:if>
			</xsl:for-each>
		</table>
		<a name="list_of_devices"></a>
		<h2><xsl:value-of select="$i18n-ecu"/>e</h2>
		<table width="100%">
			<tr>
				<td>
					<!-- generate RESULT/SECTION (table) for every device -->
					<xsl:apply-templates select="RESULT/SECTION[@OBJECT='ECU']"/>
				</td>
			</tr>
		</table>
	</body>
</html>
</xsl:template>

<!-- ================================================================= -->
<!-- displays each device and its values in a single table 			   -->
<!-- ================================================================= -->
<xsl:template match="RESULT/SECTION[@OBJECT='ECU']">
	<table xsl:use-attribute-sets="table-header_collapsed">
		<tr>
			<th xsl:use-attribute-sets="section-header">
				<span style="float: left;"><xsl:value-of select="TITLE"/></span><a name="{generate-id(.)}"></a>
				<span style="float: right"><a href="#toc"><xsl:value-of select="$i18n-back-to-top"/></a></span>
			</th>
		</tr>
		<!--
			rows should be generated dynamicly. Maybe we need to select specific elements for special presentation.
			Best would be if we can automap elements to presentation classes
		-->
		<xsl:apply-templates select="MEAS[@OBJECT='Identifikation']" />
		<!-- Coding-Link-->
		<tr>
			<td><a href="#{generate-id(TITLE)}"><xsl:value-of select="$i18n-coding"/></a></td>
			<td></td>
		</tr>
		<xsl:if test="count(child::*) > 0 and MEAS[@OBJECT='Fehler']">
			<tr>
				<td xsl:use-attribute-sets="section-title">
					<xsl:value-of select="MEAS[@OBJECT='Fehler'][1]/TITLE"/>
				</td>
				<td xsl:use-attribute-sets="table-header">
					<xsl:apply-templates select="MEAS[@OBJECT='Fehler']" />
				</td>
			</tr>
		</xsl:if>
		<xsl:apply-templates select="MEAS[@OBJECT='Messwerte']" />
		<xsl:apply-templates select="MEAS[@OBJECT='Istwerte']" />
		<xsl:apply-templates select="MEAS[@OBJECT='Fahrzeugdaten']" />
		<xsl:apply-templates select="MEAS[@OBJECT='Info 1']" />
		<xsl:apply-templates select="MEAS[@OBJECT='Info 2']" />
		<xsl:apply-templates select="MEAS[@OBJECT='Statistikwerte']" />
		<xsl:apply-templates select="MEAS[@OBJECT='Adaptionswerte']" />
	</table>
	<br />
</xsl:template>

<!-- ================================================================= -->
<!-- displays all messurements of a device if exists 				   -->
<!-- ================================================================= -->
<xsl:template match="MEAS[@OBJECT='Messwerte']
                     |MEAS[@OBJECT='Istwerte']
                     |MEAS[@OBJECT='Adaptionswerte']
                     |MEAS[@OBJECT='Statistikwerte']
                     |MEAS[@OBJECT='Fahrzeugdaten']
                     |MEAS[@OBJECT='Info 1']
                     |MEAS[@OBJECT='Info 2']">
	<xsl:if test="count(child::*[self::VALUE]) > 0">
		<tr>
			<td xsl:use-attribute-sets="section-title"><xsl:value-of select="TITLE"/></td>
			<td xsl:use-attribute-sets="table-header">
				<table width="100%">
					<xsl:for-each select="VALUE">
						<tr>
							<td style="width:60%"><xsl:value-of select="@TEXT"/></td>
							<td>
								<xsl:call-template name="textwrap">
									<xsl:with-param name="text" select="." />
								</xsl:call-template>
								<xsl:value-of select="$blank"/>
								<xsl:value-of select="@UNIT"/>
							</td>
						</tr>
					</xsl:for-each>
				</table>
			</td>
		</tr>
	</xsl:if>
</xsl:template>

<!-- ================================================================= -->
<!-- displays all identifications of a device						   -->
<!-- ================================================================= -->
<xsl:template match="MEAS[@OBJECT='Identifikation']">
	<tr>
		<td xsl:use-attribute-sets="section-title"><xsl:value-of select="TITLE"/></td>
		<td xsl:use-attribute-sets="table-header">
			<table width="100%">
				<!-- program version -->
				<xsl:if test="VALUE[@LABEL='PIF']">
					<tr>
						<td style="width:60%"><xsl:value-of select="VALUE[@LABEL='PIF']/@TEXT"/></td>
						<td>
							<xsl:call-template name="textwrap">
								<xsl:with-param name="text" select="VALUE[@LABEL='PIF']" />
							</xsl:call-template>
							<xsl:value-of select="$blank"/>
							<xsl:value-of select="VALUE[@LABEL='PIF']/@UNIT"/>
						</td>
					</tr>
				</xsl:if>
				<!-- software version -->
				<xsl:if test="VALUE[@LABEL='ZIF']">
					<tr>
						<td style="width:60%"><xsl:value-of select="VALUE[@LABEL='ZIF']/@TEXT"/></td>
						<td>
							<xsl:call-template name="textwrap">
								<xsl:with-param name="text" select="VALUE[@LABEL='ZIF']" />
							</xsl:call-template>
							<xsl:value-of select="$blank"/>
							<xsl:value-of select="VALUE[@LABEL='ZIF']/@UNIT"/>
						</td>
					</tr>
				</xsl:if>
				<!-- data set version -->
				<xsl:if test="VALUE[@LABEL='DIF']">
					<tr>
						<td style="width:60%"><xsl:value-of select="VALUE[@LABEL='DIF']/@TEXT"/></td>
						<td>
							<xsl:call-template name="textwrap">
								<xsl:with-param name="text" select="VALUE[@LABEL='DIF']" />
							</xsl:call-template>
							<xsl:value-of select="$blank"/>
							<xsl:value-of select="VALUE[@LABEL='DIF']/@UNIT"/>
						</td>
					</tr>
				</xsl:if>
				<xsl:for-each select="VALUE">
					<!-- all other version informations -->
					<xsl:if test="@LABEL!='DIF' and @LABEL!='PIF' and @LABEL!='ZIF'">
						<tr>
							<td style="width:60%"><xsl:value-of select="@TEXT"/></td>
							<td>
								<xsl:call-template name="textwrap">
									<xsl:with-param name="text" select="." />
								</xsl:call-template>
								<xsl:value-of select="$blank"/>
								<xsl:value-of select="@UNIT"/>
							</td>
						</tr>
					</xsl:if>
				</xsl:for-each>
			</table>
		</td>
	</tr>
</xsl:template>

<!-- ================================================================= -->
<!-- displays all coding values of a specific device 				   -->
<!-- ================================================================= -->
<xsl:template match="MEAS[@OBJECT='Codierung']" mode="overview">
	<table width="100%">
		<xsl:for-each select="VALUE">
			<tr>
				<td style="width:60%"><xsl:value-of select="@TEXT"/></td>
				<td>
					<xsl:call-template name="textwrap">
						<xsl:with-param name="text" select="." />
					</xsl:call-template>
					<xsl:value-of select="$blank"/>
					<xsl:value-of select="@UNIT"/>
				</td>
			</tr>
		</xsl:for-each>
	</table>
</xsl:template>

<!-- ================================================================= -->
<!-- displays enhanced values of an troublecode 					   -->
<!-- ================================================================= -->
<xsl:template match="MEAS[@OBJECT='Fehler']">
	<xsl:for-each select="VALUE">
		<xsl:value-of select="."/>
		<xsl:value-of select="$blank"/>
		<xsl:value-of select="@TEXT"/>
 	 	<table style="width: 100%; margin-left:30px">
			<xsl:for-each select="../MEAS/VALUE">
				<tr>
					<td style="width:58%"><xsl:value-of select="@TEXT"/></td>
					<td>
						<xsl:call-template name="textwrap">
							<xsl:with-param name="text" select="." />
						</xsl:call-template>
						<xsl:value-of select="$blank"/>
						<xsl:value-of select="@UNIT"/>
					</td>
				</tr>
			</xsl:for-each>
  		</table>
  	</xsl:for-each>
</xsl:template>
</xsl:stylesheet>